import { system, world } from "@minecraft/server"
import { Helper } from "../utils/Helper"
import { Adult, Baby, Item } from '../item/Rat'
function getSpawnLocation(clickedFace, clickedBlock) {
    if (clickedFace == "North") return { x: clickedBlock.x + 0.5, y: clickedBlock.y + 0.5, z: clickedBlock.z - 0.5 }
    if (clickedFace == "South") return { x: clickedBlock.x + 0.5, y: clickedBlock.y + 0.5, z: clickedBlock.z + 1.5 }
    if (clickedFace == "East") return { x: clickedBlock.x + 1.5, y: clickedBlock.y + 0.5, z: clickedBlock.z + 0.5 }
    if (clickedFace == "West") return { x: clickedBlock.x - 0.5, y: clickedBlock.y + 0.5, z: clickedBlock.z + 0.5 }
    if (clickedFace == "Up") return { x: clickedBlock.x + 0.5, y: clickedBlock.y + 1.0, z: clickedBlock.z + 0.5 }
    if (clickedFace == "Down") return { x: clickedBlock.x + 0.5, y: clickedBlock.y, z: clickedBlock.z + 0.5 }
}
const dimensions = [
    "overworld",
    "nether",
    "the_end"
]
class Rat {
    constructor() {
        this.initEvents()
    }
    initEvents() {
        world.beforeEvents.itemUseOn.subscribe(this.onPlace.bind(this))
    }
    onPlace(e) {
        const { block, blockFace, isFirstEvent, itemStack, source } = e
        if (![...Adult, ...Baby, ...Item].includes(itemStack.typeId)) return
        if (!isFirstEvent) return
        const variant = itemStack.getDynamicProperty('sf_nba:variant') ?? Item.indexOf(itemStack.typeId)
        const health = itemStack.getDynamicProperty('sf_nba:health')
        const isBaby = Baby.includes(itemStack.typeId)
        const location = getSpawnLocation(blockFace, block)
        system.run(() => {
            const rat = source.dimension.spawnEntity('sf_nba:rat', location)
            const tameable = rat.getComponent('tameable')
            if (isBaby) rat.triggerEvent("sf_nba:spawn_baby")
            if (health) rat.getComponent('health').setCurrentValue(health)
            rat.setDynamicProperty('sf_nba:owner_id', source.id)
            tameable?.tame(source)
            rat.triggerEvent("sf_nba:tame")
            rat.setProperty('sf_nba:variant', variant)
            rat.setRotation({ x: -source.getViewDirection().x, y: -source.getViewDirection().y });
            Helper.decreaseMainhandItemStack(source, 1, itemStack)
        })
    }
}
new Rat()